# coding: UTF-8

from usb_rs import Usb_rs

#1秒でタイムアウト
Timeout_default = 1

def main():
    #usb_rs通信クラスのインスタンス化
    serial = Usb_rs()

    #接続
    print("Port?")
    port = input()
    print("Speed?")
    speed = int(input())
    if not serial.open(port,speed):
        return
    
    #コマンド送受信
    while True:
        print("Please enter the command (Exit with no input)")
        command = input()
        #入力なしで終了
        if command == "":
            break
        #「?」が含まれるので送受信
        if "?" in command :
            msgBuf = serial.SendQueryMsg(command, Timeout_default)
            print(msgBuf) 
        #送信のみ
        else:
            serial.sendMsg(command)
        
    serial.close()

if __name__ == '__main__':
  main()



